<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name="btnName">#</xsl:param>
<xsl:param name="stype"></xsl:param>
<xsl:param name="smdl"></xsl:param>
<xsl:param name="ssvg"></xsl:param>
<xsl:param name="ssafe"></xsl:param>
<xsl:param name="sblk"></xsl:param>
<xsl:param name="sref"></xsl:param>
<xsl:param name="spno"></xsl:param>
<xsl:param name="spname"></xsl:param>
<xsl:param name="odr">0</xsl:param>
<xsl:param name="lang">en</xsl:param>
<xsl:template match="/">
<html>
<body>
	<xsl:if test="$sref != 'ASK'">
		<table id='tblfoundparts' width='100%' border='1'>
			<tr>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">ORDER</xsl:if><xsl:if test="$lang = 'ja'">発注</xsl:if></th>
				<th rowspan="2">
					<a href="javascript:findSafety()">
						<img src="img/safety.png" border="0"/>
					</a>
				</th>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">BLOCK</xsl:if><xsl:if test="$lang = 'ja'">ブロック</xsl:if></th>
				<th colspan="2"><xsl:if test="$lang != 'ja'">REF NO.</xsl:if><xsl:if test="$lang = 'ja'">シンボル</xsl:if></th>
				<th rowspan="2">OR</th>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">PART NO.</xsl:if><xsl:if test="$lang = 'ja'">部品番号</xsl:if></th>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">PART NAME</xsl:if><xsl:if test="$lang = 'ja'">部品名</xsl:if></th>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">DESC</xsl:if><xsl:if test="$lang = 'ja'">備考</xsl:if></th>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">MARK</xsl:if><xsl:if test="$lang = 'ja'">識別記号</xsl:if></th>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">QTY</xsl:if><xsl:if test="$lang = 'ja'">個数</xsl:if></th>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">CHG</xsl:if><xsl:if test="$lang = 'ja'">変更</xsl:if></th>
				<th rowspan="2"><xsl:if test="$lang != 'ja'">MCI</xsl:if><xsl:if test="$lang = 'ja'">変更情報</xsl:if></th>
			</tr>
			<tr>
				<th><xsl:if test="$lang != 'ja'">FIG.SCH</xsl:if><xsl:if test="$lang = 'ja'">回路図</xsl:if></th>
				<th><xsl:if test="$lang != 'ja'">FIG.PCB</xsl:if><xsl:if test="$lang = 'ja'">基板図</xsl:if></th>
			</tr>
			<xsl:if test="$ssafe != ''">
				<xsl:apply-templates select="//ROW[SAFE != '']"/>
			</xsl:if>
			<xsl:if test="$ssafe = ''">
				<xsl:if test="$stype != '' or $sblk != '' or $sref != '' or $spno != '' or $spname != '' or $ssvg != ''">
					<xsl:if test="$stype = ''">
						<xsl:if test="$sblk != ''">
							<xsl:apply-templates select="//ROW[contains(@MDL,$smdl) and @BLK=$sblk and @REF=$sref and contains(PART,$spno) and (contains(FILE1,$ssvg) or contains(FILE2,$ssvg)) and (contains(NAME,$spname) or contains(translate(DESC,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ'),$spname))]">
								<xsl:sort select="BLKNO" data-type="text" order="ascending"/>
								<xsl:sort select="@SORT" data-type="text" order="ascending"/>
							</xsl:apply-templates>
							<xsl:if test="count(//ROW[contains(@MDL,$smdl) and @BLK=$sblk and @REF=$sref and contains(PART,$spno) and (contains(FILE1,$ssvg) or contains(FILE2,$ssvg)) and (contains(NAME,$spname) or contains(translate(DESC,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ'),$spname))]) = '0'">
								<xsl:call-template name="notfound"/>
							</xsl:if>
						</xsl:if>
						<xsl:if test="$sblk = ''">
							<xsl:apply-templates select="//ROW[contains(@MDL,$smdl) and contains(@BLK,$sblk) and @REF=$sref and contains(PART,$spno) and (contains(FILE1,$ssvg) or contains(FILE2,$ssvg)) and (contains(NAME,$spname) or contains(translate(DESC,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ'),$spname))]">
								<xsl:sort select="BLKNO" data-type="text" order="ascending"/>
								<xsl:sort select="@SORT" data-type="text" order="ascending"/>
							</xsl:apply-templates>
							<xsl:if test="count(//ROW[contains(@MDL,$smdl) and contains(@BLK,$sblk) and @REF=$sref and contains(PART,$spno) and (contains(FILE1,$ssvg) or contains(FILE2,$ssvg)) and (contains(NAME,$spname) or contains(translate(DESC,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ'),$spname))]) = '0'">
								<xsl:call-template name="notfound"/>
							</xsl:if>
						</xsl:if>
					</xsl:if>
					<xsl:if test="$stype = 'C'">
						<xsl:apply-templates select="//ROW[contains(@MDL,$smdl) and contains(@BLK,$sblk) and contains(@REF,$sref) and contains(PART,$spno) and (contains(FILE1,$ssvg) or contains(FILE2,$ssvg)) and (contains(NAME,$spname) or contains(translate(DESC,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ'),$spname))]">
							<xsl:sort select="BLKNO" data-type="text" order="ascending"/>
							<xsl:sort select="@SORT" data-type="text" order="ascending"/>
						</xsl:apply-templates>
						<xsl:if test="count(//ROW[contains(@MDL,$smdl) and contains(@BLK,$sblk) and contains(@REF,$sref) and contains(PART,$spno) and (contains(FILE1,$ssvg) or contains(FILE2,$ssvg)) and (contains(NAME,$spname) or contains(translate(DESC,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ'),$spname))]) = '0'">
							<xsl:call-template name="notfound"/>
						</xsl:if>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</table>
	</xsl:if>
	<xsl:if test="$sref = 'ASK'">
		<table align="center" cellpadding="5">
			<tr><td>
				<table border="1">
					<tr>
						<th><xsl:if test="$lang != 'ja'">MARK</xsl:if><xsl:if test="$lang = 'ja'">識別記号</xsl:if></th>
						<th><xsl:if test="$lang != 'ja'">MODEL NO.</xsl:if><xsl:if test="$lang = 'ja'">機種名</xsl:if></th>
					</tr>
					<xsl:apply-templates select="//HEAD/MODEL"/>
				</table>
				<br/>
				<table border="1">
					<tr>
						<th><xsl:if test="$lang != 'ja'">BLOCK NO.</xsl:if><xsl:if test="$lang = 'ja'">ブロックNo.</xsl:if></th>
						<th><xsl:if test="$lang != 'ja'">BLOCK NAME</xsl:if><xsl:if test="$lang = 'ja'">ブロック名</xsl:if></th>
						<th><xsl:if test="$lang != 'ja'">ROW QTY</xsl:if><xsl:if test="$lang = 'ja'">部品行数</xsl:if></th>
						<th><xsl:if test="$lang != 'ja'">MARK</xsl:if><xsl:if test="$lang = 'ja'">識別記号</xsl:if></th>
					</tr>
					<xsl:apply-templates select="//HEAD/BLOCK"/>
				</table>
			</td></tr>
		</table>
	</xsl:if>
</body>
</html>
</xsl:template>

<xsl:template match="PARTSLIST/ROW">
	<tr style="background:white">
		<xsl:attribute name="class">
			<xsl:value-of select="@BLK"/><xsl:value-of select="@REF"/>
		</xsl:attribute>
		<td align="center" nowrap="nowrap">
			<input type="button" id="odrBtn">
				<xsl:attribute name="value">
					<xsl:value-of select="$btnName"/>
				</xsl:attribute>
				<xsl:attribute name="onclick">
					addBasket('<xsl:value-of select="@BLK"/>','<xsl:value-of select="@REF"/>','<xsl:value-of select="PART"/>')
				</xsl:attribute>
				<xsl:if test="@CHG[. = 'D']">
					<xsl:attribute name="disabled">
						true
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="$odr = '0'">
					<xsl:attribute name="disabled">
						true
					</xsl:attribute>
				</xsl:if>
			</input>
		</td>
		<td align="center" nowrap="nowrap">
			<xsl:if test="SAFE[. != '']">
				<img src="img/safety.png" border="0"/>
			</xsl:if>
			<xsl:if test="SAFE[. = '']">
				<br/>
			</xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="BLKNO[. != '']"><xsl:value-of select="BLKNO"/></xsl:if>
			<xsl:if test="BLKNO[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="FILE1[. != ''] and FILE1[. != 'unknown']">
				<a onmouseover="this.style.cursor='pointer';this.style.color='red';" onmouseout="this.style.color='royalblue';">
					<xsl:attribute name="onclick">
						svgopen('<xsl:value-of select="FILE1"/>','<xsl:value-of select="FILE2"/>','<xsl:value-of select="@REF"/>','<xsl:value-of select="@BLK"/>','svg1','svg2')
					</xsl:attribute>
					<xsl:if test="@REF[. != '']"><xsl:value-of select="@REF"/></xsl:if>
					<xsl:if test="@REF[. = '']"><br/></xsl:if>
				</a>
			</xsl:if>
			<xsl:if test="FILE1[. = ''] or FILE1[. = 'unknown']">
				<xsl:if test="@REF[. != '']"><xsl:value-of select="@REF"/></xsl:if>
				<xsl:if test="@REF[. = '']"><br/></xsl:if>
			</xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="FILE2[. != ''] and FILE2[. != 'unknown']">
				<a onmouseover="this.style.cursor='pointer';this.style.color='red';" onmouseout="this.style.color='royalblue';">
					<xsl:attribute name="onclick">
						svgopen('<xsl:value-of select="FILE2"/>','<xsl:value-of select="FILE1"/>','<xsl:value-of select="@REF"/>','<xsl:value-of select="@BLK"/>','svg2','svg1')
					</xsl:attribute>
					<xsl:if test="@REF[. != '']"><xsl:value-of select="@REF"/></xsl:if>
					<xsl:if test="@REF[. = '']"><br/></xsl:if>
				</a>
			</xsl:if>
			<xsl:if test="FILE2[. = ''] or FILE2[. = 'unknown']">
				<xsl:if test="@REF[. != '']"><xsl:value-of select="@REF"/></xsl:if>
				<xsl:if test="@REF[. = '']"><br/></xsl:if>
			</xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="OR[. != '']"><xsl:value-of select="OR"/></xsl:if>
			<xsl:if test="OR[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="PART[. != '']"><xsl:value-of select="PART"/></xsl:if>
			<xsl:if test="PART[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="NAME[. != '']"><xsl:value-of select="NAME"/></xsl:if>
			<xsl:if test="NAME[. = '']"><br/></xsl:if>
		</td>
		<td>
			<xsl:if test="DESC[. != '']"><xsl:value-of select="DESC"/></xsl:if>
			<xsl:if test="DESC[. = '']"><br/></xsl:if>
		</td>
		<td>
			<xsl:value-of select="@MDL"/>
<!--
			<xsl:if test="AREA[. != '']"><xsl:value-of select="AREA"/></xsl:if>
			<xsl:if test="AREA[. = '']"><br/></xsl:if>
-->
		</td>
		<td nowrap="nowrap">
			<xsl:if test="QTY[. != '']"><xsl:value-of select="QTY"/></xsl:if>
			<xsl:if test="QTY[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap" align="center">
			<xsl:if test="@CHG[. != '']"><xsl:value-of select="@CHG"/></xsl:if>
			<xsl:if test="@CHG[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<a>
				<xsl:attribute name="href">
					<xsl:value-of select="RESERVED1/@LINK"/>
				</xsl:attribute>
				<xsl:attribute name="target">_blank</xsl:attribute>
				<xsl:if test="RESERVED1[. != '']"><xsl:value-of select="RESERVED1"/></xsl:if>
				<xsl:if test="RESERVED1[. = '']"><br/></xsl:if>
			</a>
		</td>
	</tr>
</xsl:template>

<xsl:template name="notfound">
	<tr>
		<td colspan="14" align="center">
			<font color="red">
				<xsl:if test="$lang != 'ja'">************  Not Found !!  ************</xsl:if>
				<xsl:if test="$lang = 'ja'">************  該当する部品はありません。  ************</xsl:if>
			</font>
		</td>
	</tr>
</xsl:template>

<xsl:template match="PARTSLIST/HEAD/MODEL">
	<tr>
		<td><xsl:value-of select="@MDL"/></td>
		<td><xsl:value-of select="."/></td>
	</tr>
</xsl:template>

<xsl:template match="PARTSLIST/HEAD/BLOCK">
	<tr>
		<td>
			<a onmouseover="this.style.cursor='pointer';this.style.color='red';" onmouseout="this.style.color='royalblue';">
				<xsl:attribute name="onclick">
					findBlock('<xsl:value-of select="@BLK"/>')
				</xsl:attribute>
				<xsl:value-of select="NO"/>
			</a>
		</td>
		<td><xsl:value-of select="NAME"/></td>
		<td align="right"><xsl:value-of select="QTY"/></td>
		<td><xsl:value-of select="@MDL"/></td>
<!--
		<td><xsl:call-template name="text"><xsl:with-param name="txtmdl"><xsl:value-of select="@MDL"/></xsl:with-param></xsl:call-template></td>
-->
	</tr>
</xsl:template>

<xsl:template name="text">
	<xsl:param name="txtmdl" select="."/>
	<xsl:for-each select="//MODEL">
		<xsl:if test="contains($txtmdl, @MDL)"><xsl:value-of select="@LBL"/>,</xsl:if>
<!--
		<xsl:if test="@LBL = ''">
			<xsl:if test="contains($txtmdl, @MDL)"><xsl:value-of select="@MDL"/>,</xsl:if>
		</xsl:if>
		<xsl:if test="@LBL != ''">
			<xsl:if test="contains($txtmdl, @MDL)"><xsl:value-of select="@LBL"/>,</xsl:if>
		</xsl:if>
-->
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
